/* @(#) somx/phonedir.c 2.3 1/20/94 09:35:15 [5/15/94 17:57:58] */

/*
 * 96F8647, 96F8648, 96F8850 (C) Copyright IBM Corp. 1992, 1994
 * All Rights Reserved
 * Licensed Materials - Property of IBM
 *
 * DISCLAIMER OF WARRANTIES.
 * The following [enclosed] code is sample code created by IBM
 * Corporation. This sample code is not part of any standard or IBM
 * product and is provided to you solely for the purpose of assisting
 * you in the development of your applications.  The code is provided
 * "AS IS". IBM MAKES NO WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT
 * NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE, REGARDING THE FUNCTION OR PERFORMANCE OF
 * THIS CODE.  IBM shall not be liable for any damages arising out of
 * your use of the sample code, even if they have been advised of the
 * possibility of such damages.
 *
 * DISTRIBUTION.
 * This sample code can be freely distributed, copied, altered, and
 * incorporated into other software, provided that it bears the above
 * Copyright notice and DISCLAIMER intact.
 */


#include <somp.h>
#define  phoneDir_Class_Source
#include "phonedir.ih"


/*==========================================================================*
 * This function is called when we're dynamically loaded via somFindClass
 *==========================================================================*/
SOMEXTERN void SOMLINK SOMInitModule (long majorVersion, long minorVersion)
{
   phoneDirNewClass(0, 0);
   dirEntryNewClass(0, 0);
}

/*
 ===============================================================================
 Operation:  addEntry
 Purpose  :  Adds a dirEntry object to the directory.
 ===============================================================================
 */

SOM_Scope long  SOMLINK addEntry(phoneDir somSelf,
                dirEntry entry)
{
    Environment *myEnv;

    phoneDirData *somThis = phoneDirGetData(somSelf);
    phoneDirMethodDebug("phoneDir","addEntry");

    myEnv = SOM_CreateLocalEnvironment();

    if (sequenceLength(_directory) < sequenceMaximum(_directory)) {
        sequenceElement(_directory, sequenceLength(_directory)) = entry;
        sequenceLength(_directory)++;
        _sompSetDirty (somSelf, myEnv);
        SOM_DestroyLocalEnvironment(myEnv);
        return (long) 0;
    } else {
        SOM_DestroyLocalEnvironment(myEnv);
        return (long) -1;
    }
}


/*
 ===============================================================================
 Operation:  printDirInfo
 Purpose  :  Invokes lsEntry for each instance of direntry.
 ===============================================================================
 */

SOM_Scope void  SOMLINK printDirInfo(phoneDir somSelf)
{
    int probe;

    phoneDirData *somThis = phoneDirGetData(somSelf);
    phoneDirMethodDebug("phoneDir","printDirInfo");

    if (sequenceLength(_directory) > 0) {
       printf("\n");
       printf("Name                Phone\n");
       printf("----------------    ----------------\n");
       for (probe = 0; probe < sequenceLength(_directory); probe++) {
          _lsEntry(sequenceElement(_directory, probe));
       }
    } else {
        printf ("\nDirectory is Empty\n");
    }

}

/*
 ===============================================================================
 Operation:  getEntry
 Purpose  :  returns a pointer to the list entry with name == entryID.
             If a matching entry is not found, returns NULL.
 ===============================================================================
 */

SOM_Scope dirEntry  SOMLINK getEntry(phoneDir somSelf,
                string entryID)
{
    int probe;
    char *probename;

    phoneDirData *somThis = phoneDirGetData(somSelf);
    phoneDirMethodDebug("phoneDir","getEntry");

    for (probe = 0;probe < sequenceLength(_directory);probe++) {
      probename = dirEntry__get_name(sequenceElement(_directory, probe));
      if (strcmp(probename, entryID) == 0)
          return (sequenceElement(_directory, probe));
    } /* endfor */

    return (dirEntry) NULL;
}

/*
 ===============================================================================
 Operation:  dropEntry
 Purpose  :  delete an entry from the directory.
 *
 *  dropEntry removes the entry with name == entryID from the directory
 *  array, and returns a pointer to the dropped entry.
 *  If a matching entry is not found, it returns NULL.
 *  The client application must use sompDeleteObject on the returned object
 *  to delete it from the IO Group.  The client must also free the dirEntry
 *  Object returned.
 ===============================================================================
 */

SOM_Scope dirEntry  SOMLINK dropEntry(phoneDir somSelf,
                     string entryID)
{
    int probe;
    char *probename;
    dirEntry dptr;
    Environment *myEnv;

    phoneDirData *somThis = phoneDirGetData(somSelf);
    phoneDirMethodDebug("phoneDir","dropEntry");

    myEnv = SOM_CreateLocalEnvironment();

    for (probe = 0;probe < sequenceLength(_directory);probe++) {
        probename = dirEntry__get_name(sequenceElement(_directory, probe));
        if (strcmp(probename, entryID) == 0) {
            dptr = sequenceElement(_directory, probe);
            sequenceLength(_directory)--;
            for (probe=0; probe < sequenceLength(_directory); probe++) {
                sequenceElement(_directory, probe) =
                sequenceElement(_directory, (probe + 1));
            }
            _sompSetDirty (somSelf, myEnv);
            SOM_DestroyLocalEnvironment(myEnv);
            return dptr;
        } /* endif */
    } /* endfor */

    SOM_DestroyLocalEnvironment(myEnv);
    return (dirEntry) NULL;
}

/*
 ===============================================================================
 Operation: somInit
 Purpose  : init instance
 Notes    : The sequence data structure is defined as:

               typedef struct {
                 unsigned long _maximum;
                 unsigned long _length;
                 dirEntry *_buffer;
               } _IDL_SEQUENCE_dirEntry;

 ===============================================================================
*/


SOM_Scope void  SOMLINK somInit(phoneDir somSelf)
{
    static int firstTime = 1;

    phoneDirData *somThis = phoneDirGetData(somSelf);
    phoneDirMethodDebug("phoneDir","somInit");

    parent_somInit(somSelf);

    sequenceMaximum(_directory) = MAXDIRSIZE;
    sequenceLength(_directory) = 0;
    _directory._buffer = SOMMalloc(sizeof (dirEntry) * MAXDIRSIZE);

}


